document.addEventListener('DOMContentLoaded', function () {
    const togglePassword = document.querySelector('.show-password');
    const passwordField = document.querySelector('#senha');

    togglePassword.addEventListener('click', function () {
        // Alterna o tipo de campo entre 'password' e 'text'
        const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordField.setAttribute('type', type);

        // Altera o ícone conforme o estado
        this.textContent = type === 'password' ? 'visibility' : 'visibility_off';
    });
});
// main.js
document.addEventListener('DOMContentLoaded', function () {
    // Gráfico de visitas atuais
    const ctx1 = document.getElementById('currentVisitsChart').getContext('2d');
    const currentVisitsChart = new Chart(ctx1, {
        type: 'pie',
        data: {
            labels: ['América', 'Ásia', 'Europa', 'África'],
            datasets: [{
                data: [43.8, 31.3, 18.8, 6.3],
                backgroundColor: ['#42a5f5', '#66bb6a', '#ffa726', '#ef5350']
            }]
        }
    });

    // Gráfico de visitas ao site
    const ctx2 = document.getElementById('websiteVisitsChart').getContext('2d');
    const websiteVisitsChart = new Chart(ctx2, {
        type: 'bar',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep'],
            datasets: [{
                label: 'Team A',
                data: [40, 60, 50, 70, 90, 50, 60, 80, 70],
                backgroundColor: '#42a5f5'
            }, {
                label: 'Team B',
                data: [60, 40, 70, 50, 60, 80, 70, 50, 90],
                backgroundColor: '#ffca28'
            }]
        }
    });
});


// Código inicial para interações básicas
document.addEventListener('DOMContentLoaded', function () {
    console.log("Dashboard carregado com sucesso!");
});
function showTable(year) {
    fetch(`/emenda/fetchEmendasByYear/${year}`)
        .then(response => response.json())
        .then(data => {
            const tableBody = document.querySelector(`#${year} tbody`);
            tableBody.innerHTML = ''; // Limpar conteúdo antigo

            data.forEach(emenda => {
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${emenda.numero}</td>
                    <td>${emenda.objeto}</td>
                    <td>${emenda.vereador}</td>
                    <td>R$ ${emenda.valor}</td>
                    <td>R$ ${emenda.suplementacao}</td>
                    <td>R$ ${emenda.total}</td>
                    <td>${emenda.dotacao}</td>
                    <td>${emenda.empenho}</td>
                    <td class="${emenda.situacao.toLowerCase().replace(' ', '-')}">${emenda.situacao}</td>
                `;
                tableBody.appendChild(row);
            });
        });
}
