<?= $this->extend('layout/layout') ?>

<?= $this->section('content') ?>
<div class="container mt-5">
    <h4 class="title has-text-centered">Listagem de Emendas</h4>

    <!-- Filtro de Ano e Tipo com centralização e espaçamento -->
    <form method="GET" action="/emenda" class="is-flex is-justify-content-center mb-4">
        <div class="field is-grouped">
            <div class="control mr-3">
                <div class="select">
                    <select name="ano_id">
                        <option value="">Selecione o Ano</option>
                        <?php foreach ($anos as $ano): ?>
                            <option value="<?= $ano['id'] ?>"><?= esc($ano['ano']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="control mr-3">
                <div class="select">
                    <select name="tipo_id">
                        <option value="">Selecione o Tipo</option>
                        <?php foreach ($tipos as $tipo): ?>
                            <option value="<?= $tipo['id'] ?>"><?= esc($tipo['nome']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="control">
                <button type="submit" class="button is-primary">Filtrar</button>
            </div>
        </div>
    </form>

    <div class="is-flex mb-4">
        <a href="/emenda/create" class="button is-primary">Cadastrar Nova Emenda</a>
    </div>

    <table class="table is-fullwidth is-striped">
        <thead>
        <tr>
            <th>ID</th>
            <th>Número</th>
            <th>Vereador</th>
            <th>Valor</th>
            <th>Suplementação</th>
            <th>Total</th>
            <th>Ações</th>
        </tr>
        </thead>
        <tbody>
        <?php if (!empty($emendas)): ?>
            <?php foreach ($emendas as $emenda): ?>
                <tr>
                    <td><?= esc($emenda['id']) ?></td>
                    <td><?= esc($emenda['numero']) ?></td>
                    <td><?= esc($emenda['vereador']) ?></td>
                    <td><?= esc($emenda['valor']) ?></td>
                    <td><?= esc($emenda['suplementacao']) ?></td>
                    <td><?= esc($emenda['total']) ?></td>
                    <td>
                        <a href="/emenda/edit/<?= esc($emenda['id']) ?>" class="button is-small is-warning">Editar</a>
                        <a href="/emenda/delete/<?= $emenda['id'] ?>" class="button is-danger is-small" onclick="return confirm('Tem certeza que deseja excluir esta emenda?')">Excluir</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="7">Nenhuma emenda cadastrada.</td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>
<?= $this->endSection() ?>
