<?= $this->extend('layout/layout') ?>

<?= $this->section('content') ?>
<div class="container mt-5">
    <h2 class="title is-4">Editar Emenda</h2>

    <?php if (session()->getFlashdata('success')): ?>
        <div class="notification is-success">
            <?= session()->getFlashdata('success') ?>
        </div>
    <?php endif; ?>

    <form action="/emenda/update/<?= $emenda['id'] ?>" method="post" enctype="multipart/form-data">
        <!-- Tipo de Emenda -->
        <div class="field">
            <label class="label" for="tipo_id">Tipo de Emenda</label>
            <div class="control">
                <div class="select is-fullwidth">
                    <select name="tipo_id" required>
                        <option value="" disabled>Selecione o Tipo</option>
                        <?php foreach ($tipos as $tipo): ?>
                            <option value="<?= $tipo['id'] ?>" <?= $tipo['id'] == $emenda['tipo_id'] ? 'selected' : '' ?>><?= $tipo['nome'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
        </div>
        <!-- Número da Emenda -->
        <div class="field">
            <label class="label" for="numero">Número</label>
            <div class="control">
                <input class="input" type="text" name="numero" required value="<?= esc($emenda['numero']) ?>">
            </div>
        </div>

        <!-- Objeto da Emenda -->
        <div class="field">
            <label class="label" for="objeto">Objeto</label>
            <div class="control">
                <textarea class="textarea" name="objeto" required><?= esc($emenda['objeto']) ?></textarea>
            </div>
        </div>

        <!-- Outros Campos -->
        <div class="field">
            <label class="label" for="vereador">Vereador</label>
            <div class="control">
                <input class="input" type="text" name="vereador" required value="<?= esc($emenda['vereador']) ?>">
            </div>
        </div>

        <div class="field">
            <label class="label" for="valor">Valor</label>
            <div class="control">
                <input class="input" type="number" name="valor" step="0.01" required value="<?= esc($emenda['valor']) ?>">
            </div>
        </div>

        <div class="field">
            <label class="label" for="suplementacao">Suplementação</label>
            <div class="control">
                <input class="input" type="number" name="suplementacao" step="0.01" value="<?= esc($emenda['suplementacao']) ?>">
            </div>
        </div>

        <div class="field">
            <label class="label" for="dotacao">Dotação</label>
            <div class="control">
                <textarea class="textarea" name="dotacao"><?= esc($emenda['dotacao']) ?></textarea>
            </div>
        </div>

        <div class="field">
            <label class="label" for="empenho">Empenho</label>
            <div class="control">
                <input class="input" type="number" name="empenho" step="0.01" required value="<?= esc($emenda['empenho']) ?>">
            </div>
        </div>

        <div class="field">
            <label class="label" for="total">Total</label>
            <div class="control">
                <input class="input" type="number" name="total" step="0.01" required value="<?= esc($emenda['total']) ?>">
            </div>
        </div>

        <div class="field">
            <label class="label" for="situacao">Situação</label>
            <div class="control">
                <textarea class="textarea" name="situacao"><?= esc($emenda['situacao']) ?></textarea>
            </div>
        </div>

        <div class="field">
            <label class="label">Documentos Existentes</label>
            <div class="control">
                <?php if (!empty($arquivos)): ?>
                    <ul>
                        <?php foreach ($arquivos as $arquivo): ?>
                            <li>

                                <a href="<?= base_url('emenda/downloadArquivo/' . $arquivo['id']) ?>">
                                    <?= esc($arquivo['nome_arquivo']) ?>
                                </a>



                                <a href="/emenda/deleteArquivo/<?= esc($arquivo['id']) ?>" class="button is-small is-danger" onclick="return confirm('Tem certeza que deseja excluir este arquivo?')">Excluir</a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p>Não há arquivos vinculados a esta emenda.</p>
                <?php endif; ?>
            </div>
        </div>



        <div class="field">
            <label class="label" for="documentos">Documentos</label>
            <div class="control">
                <input class="input" type="file" name="documentos[]" multiple>
            </div>
            <p class="help">Selecione um ou mais arquivos para anexar à emenda.</p>
        </div>



        <!-- Botão de Salvar -->
        <div class="field">
            <div class="control">
                <button type="submit" class="button is-primary">Salvar Alterações</button>
            </div>
        </div>
    </form>
</div>
<?= $this->endSection() ?>
