<?= $this->extend('layout/layout') ?>

<?= $this->section('content') ?>
<div class="container mt-5">
    <h2 class="title is-4">Cadastrar Nova Emenda</h2>

    <form action="/emenda/store" method="post" enctype="multipart/form-data">
        <!-- Tipo de Emenda -->
        <div class="field">
            <label class="label" for="tipo_id">Tipo de Emenda</label>
            <div class="control">
                <div class="select is-fullwidth">
                    <select name="tipo_id" required>
                        <option value="" disabled selected>Selecione o Tipo</option>
                        <?php foreach ($tipos as $tipo): ?>
                            <option value="<?= $tipo['id'] ?>"><?= $tipo['nome'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="field">
            <label class="label" for="ano_id">Ano</label>
            <div class="control">
                <div class="select is-fullwidth">
                    <select name="ano_id" required>
                        <option value="" disabled>Selecione o Ano</option>
                        <?php foreach ($anos as $ano): ?>
                            <option value="<?= $ano['id'] ?>" <?= isset($emenda['ano_id']) && $emenda['ano_id'] == $ano['id'] ? 'selected' : '' ?>><?= esc($ano['ano']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
        </div>

        <!-- Número da Emenda -->
        <div class="field">
            <label class="label" for="numero">Número</label>
            <div class="control">
                <input class="input" type="text" name="numero" required>
            </div>
        </div>

        <!-- Objeto da Emenda -->
        <div class="field">
            <label class="label" for="objeto">Objeto</label>
            <div class="control">
                <textarea class="textarea" name="objeto" required></textarea>
            </div>
        </div>

        <!-- Outros Campos -->
        <div class="field">
            <label class="label" for="vereador">Vereador</label>
            <div class="control">
                <input class="input" type="text" name="vereador" required>
            </div>
        </div>

        <div class="field">
            <label class="label" for="valor">Valor</label>
            <div class="control">
                <input class="input" type="number" name="valor" step="0.01" required>
            </div>
        </div>

        <div class="field">
            <label class="label" for="suplementacao">Suplementação</label>
            <div class="control">
                <input class="input" type="number" name="suplementacao" step="0.01">
            </div>
        </div>

        <div class="field">
            <label class="label" for="dotacao">Dotação</label>
            <div class="control">
                <textarea class="textarea" name="dotacao"></textarea>
            </div>
        </div>
        <div class="field">
            <label class="label" for="empenho">Empenho</label>
            <div class="control">
                <input class="input" type="number" name="empenho" step="0.01" required>
            </div>
        </div>
        <div class="field">
            <label class="label" for="total">Total</label>
            <div class="control">
                <input class="input" type="number" name="total" step="0.01" required>
            </div>
        </div>
        <div class="field">
            <label class="label" for="situacao">Situação</label>
            <div class="control">
                <textarea class="textarea" name="situacao"></textarea>
            </div>
        </div>

        <!-- Upload de Arquivos -->
        <div class="field">
            <label class="label" for="documentos">Documentos</label>
            <div class="control">
                <input class="input" type="file" name="documentos[]" multiple>
            </div>
            <p class="help">Selecione um ou mais arquivos para anexar à emenda.</p>
        </div>

        <!-- Botão de Enviar -->
        <div class="field">
            <div class="control">
                <button type="submit" class="button is-primary">Salvar Emenda</button>
            </div>
        </div>
    </form>
</div>
<?= $this->endSection() ?>
<?php if (session()->getFlashdata('success')): ?>
    <div class="notification is-success">
        <?= session()->getFlashdata('success') ?>
    </div>
<?php endif; ?>
