<?= $this->extend('layout/layout') ?>

<?= $this->section('content') ?>
<div class="container mt-5">
    <h4 class="title is-4">Gerenciar Anos</h4>
    <a href="/anos/create" class="button is-primary mb-3">Adicionar Novo Ano</a>
    <table class="table is-fullwidth is-striped">
        <thead>
        <tr>
            <th>ID</th>
            <th>Ano</th>
            <th>Ações</th>
        </tr>
        </thead>
        <tbody>
        <?php if (!empty($anos) && is_array($anos)): ?>
            <?php foreach ($anos as $ano): ?>
                <tr>
                    <td><?= esc($ano['id']) ?></td>
                    <td><?= esc($ano['ano']) ?></td>
                    <td>
                        <a href="/anos/delete/<?= esc($ano['id']) ?>" class="button is-danger is-small">Excluir</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="3">Nenhum ano cadastrado.</td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>
<?= $this->endSection() ?>
