<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
class CreateEmendaArquivosTable extends Migration
{
    
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'auto_increment' => true
            ],
            'emenda_id' => [
                'type'       => 'INT',
                'unsigned'   => true,
            ],
            'nome_arquivo' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'caminho' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'tipo' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'null'       => true,
            ],
            'tamanho' => [
                'type' => 'INT',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('emenda_id', 'emendas', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('emenda_arquivos');
    }

    public function down()
    {
        $this->forge->dropTable('emenda_arquivos');
    }
}
