<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateEmendasTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'unsigned'       => true,
                'auto_increment' => true
            ],
            'tipo_id' => [
                'type'       => 'INT',
                'unsigned'   => true,
            ],
            'ano_id' => [
                'type'     => 'INT',
                'unsigned' => true,
                'null'     => true,
            ],
            'numero' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
            ],
            'objeto' => [
                'type' => 'TEXT',
            ],
            'vereador' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'valor' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'suplementacao' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
                'null'       => true,
            ],
            'total' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
                'null'       => true,
            ],
            'dotacao' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'empenho' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'null'       => true,
            ],
            'situacao' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('tipo_id', 'tipos', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('ano_id', 'anos', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('emendas');
    }

    public function down()
    {
        $this->forge->dropTable('emendas');
    }
}
