<?php
namespace App\Controllers;

use App\Models\AnoModel;
use App\Models\EmendaModel;
use App\Models\EmendaArquivoModel;
use App\Models\TipoModel;

class Home extends BaseController
{
    public function index()
    {
        $anoModel = new AnoModel();
        $emendaModel = new EmendaModel();
        $emendaArquivoModel = new EmendaArquivoModel();
        $tipoModel = new TipoModel();

        // Carrega todos os anos para o filtro
        $data['anos'] = $anoModel->findAll();

        // Busca todas as emendas
        $emendas = $emendaModel->findAll();

        foreach ($emendas as &$emenda) {
            // Busca e formata os arquivos associados a cada emenda
            $arquivos = $emendaArquivoModel->where('emenda_id', $emenda['id'])->findAll();
            foreach ($arquivos as &$arquivo) {
                // Adiciona o caminho completo para download
                $arquivo['caminho'] = base_url('writable/' . $arquivo['caminho']);
            }
            $emenda['arquivos'] = $arquivos;

            // Busca e adiciona o nome do tipo
            $tipo = $tipoModel->find($emenda['tipo_id']);
            $emenda['tipo_nome'] = $tipo ? $tipo['nome'] : 'Emenda';
        }

        $data['emendas'] = $emendas;

        return view('welcome_message', $data);
    }
}
